#ifndef _BASE_H_
#define _BASE_H_

#include <errno.h>

extern int at_android; /* Indicate the current environment. */
extern float calc_diff_time(struct timespec *, struct timespec *);
extern int file_exists(char *);
extern void check_current_env();

/* sys_err show the error message in detail and then exit. */
#define system_error() { \
	printf("[ERROR] file:%s line:%d -- %s\n", \
			__FILE__, __LINE__, strerror(errno)); \
	exit(-1); \
}

/* debug_print show message and corresponding level. */
#ifdef DEBUG
  #define debug_print(level, ...) printf("["level"]\t" __VA_ARGS__ )
#else
  #define debug_print(level, ...)
#endif

#define ONE_K		1024
#define ONE_M		1024*1024
#define BUFF_SIZE	ONE_K

#define rand_max (float)RAND_MAX
#define r() ((rand()/rand_max)*2-1)

#endif /* _BASE_H_ */
